package zio.aws.iam.model
import zio.aws.iam.model.primitives.ExistingUserNameType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccessKeyLastUsedResponse(
    userName: Optional[ExistingUserNameType] = Optional.Absent,
    accessKeyLastUsed: Optional[zio.aws.iam.model.AccessKeyLastUsed] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse = {
    import GetAccessKeyLastUsedResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .optionallyWith(accessKeyLastUsed.map(value => value.buildAwsValue()))(
        _.accessKeyLastUsed
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly =
    zio.aws.iam.model.GetAccessKeyLastUsedResponse.wrap(buildAwsValue())
}
object GetAccessKeyLastUsedResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccessKeyLastUsedResponse =
      zio.aws.iam.model.GetAccessKeyLastUsedResponse(
        userName.map(value => value),
        accessKeyLastUsed.map(value => value.asEditable)
      )
    def userName: Optional[ExistingUserNameType]
    def accessKeyLastUsed
        : Optional[zio.aws.iam.model.AccessKeyLastUsed.ReadOnly]
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getAccessKeyLastUsed
        : ZIO[Any, AwsError, zio.aws.iam.model.AccessKeyLastUsed.ReadOnly] =
      AwsError.unwrapOptionField("accessKeyLastUsed", accessKeyLastUsed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse
  ) extends zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly {
    override val userName: Optional[ExistingUserNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userName())
        .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val accessKeyLastUsed
        : Optional[zio.aws.iam.model.AccessKeyLastUsed.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKeyLastUsed())
        .map(value => zio.aws.iam.model.AccessKeyLastUsed.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse
  ): zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly = new Wrapper(impl)
}
