package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetGroupResponse(
    group: zio.aws.iam.model.Group,
    users: Iterable[zio.aws.iam.model.User],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetGroupResponse = {
    import GetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetGroupResponse
      .builder()
      .group(group.buildAwsValue())
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetGroupResponse.ReadOnly =
    zio.aws.iam.model.GetGroupResponse.wrap(buildAwsValue())
}
object GetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetGroupResponse =
      zio.aws.iam.model.GetGroupResponse(
        group.asEditable,
        users.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def group: zio.aws.iam.model.Group.ReadOnly
    def users: List[zio.aws.iam.model.User.ReadOnly]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getGroup: ZIO[Any, Nothing, zio.aws.iam.model.Group.ReadOnly] =
      ZIO.succeed(group)
    def getUsers: ZIO[Any, Nothing, List[zio.aws.iam.model.User.ReadOnly]] =
      ZIO.succeed(users)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetGroupResponse
  ) extends zio.aws.iam.model.GetGroupResponse.ReadOnly {
    override val group: zio.aws.iam.model.Group.ReadOnly =
      zio.aws.iam.model.Group.wrap(impl.group())
    override val users: List[zio.aws.iam.model.User.ReadOnly] = impl
      .users()
      .asScala
      .map { item =>
        zio.aws.iam.model.User.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetGroupResponse
  ): zio.aws.iam.model.GetGroupResponse.ReadOnly = new Wrapper(impl)
}
