package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MarkerType, MaxItemsType, JobIDType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetOrganizationsAccessReportRequest(
    jobId: JobIDType,
    maxItems: Optional[MaxItemsType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    sortKey: Optional[zio.aws.iam.model.SortKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest = {
    import GetOrganizationsAccessReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
      .builder()
      .jobId(JobIDType.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(sortKey.map(value => value.unwrap))(_.sortKey)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetOrganizationsAccessReportRequest.ReadOnly =
    zio.aws.iam.model.GetOrganizationsAccessReportRequest.wrap(buildAwsValue())
}
object GetOrganizationsAccessReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetOrganizationsAccessReportRequest =
      zio.aws.iam.model.GetOrganizationsAccessReportRequest(
        jobId,
        maxItems.map(value => value),
        marker.map(value => value),
        sortKey.map(value => value)
      )
    def jobId: JobIDType
    def maxItems: Optional[MaxItemsType]
    def marker: Optional[MarkerType]
    def sortKey: Optional[zio.aws.iam.model.SortKeyType]
    def getJobId: ZIO[Any, Nothing, JobIDType] = ZIO.succeed(jobId)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getSortKey: ZIO[Any, AwsError, zio.aws.iam.model.SortKeyType] =
      AwsError.unwrapOptionField("sortKey", sortKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
  ) extends zio.aws.iam.model.GetOrganizationsAccessReportRequest.ReadOnly {
    override val jobId: JobIDType =
      zio.aws.iam.model.primitives.JobIDType(impl.jobId())
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val sortKey: Optional[zio.aws.iam.model.SortKeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortKey())
        .map(value => zio.aws.iam.model.SortKeyType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
  ): zio.aws.iam.model.GetOrganizationsAccessReportRequest.ReadOnly =
    new Wrapper(impl)
}
