package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MarkerType,
  BooleanType,
  IntegerType,
  DateType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetOrganizationsAccessReportResponse(
    jobStatus: zio.aws.iam.model.JobStatusType,
    jobCreationDate: DateType,
    jobCompletionDate: Optional[DateType] = Optional.Absent,
    numberOfServicesAccessible: Optional[IntegerType] = Optional.Absent,
    numberOfServicesNotAccessed: Optional[IntegerType] = Optional.Absent,
    accessDetails: Optional[Iterable[zio.aws.iam.model.AccessDetail]] =
      Optional.Absent,
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    errorDetails: Optional[zio.aws.iam.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse = {
    import GetOrganizationsAccessReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
      .builder()
      .jobStatus(jobStatus.unwrap)
      .jobCreationDate(DateType.unwrap(jobCreationDate): Instant)
      .optionallyWith(
        jobCompletionDate.map(value => DateType.unwrap(value): Instant)
      )(_.jobCompletionDate)
      .optionallyWith(
        numberOfServicesAccessible.map(value =>
          IntegerType.unwrap(value): Integer
        )
      )(_.numberOfServicesAccessible)
      .optionallyWith(
        numberOfServicesNotAccessed.map(value =>
          IntegerType.unwrap(value): Integer
        )
      )(_.numberOfServicesNotAccessed)
      .optionallyWith(
        accessDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessDetails)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly =
    zio.aws.iam.model.GetOrganizationsAccessReportResponse.wrap(buildAwsValue())
}
object GetOrganizationsAccessReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetOrganizationsAccessReportResponse =
      zio.aws.iam.model.GetOrganizationsAccessReportResponse(
        jobStatus,
        jobCreationDate,
        jobCompletionDate.map(value => value),
        numberOfServicesAccessible.map(value => value),
        numberOfServicesNotAccessed.map(value => value),
        accessDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def jobStatus: zio.aws.iam.model.JobStatusType
    def jobCreationDate: DateType
    def jobCompletionDate: Optional[DateType]
    def numberOfServicesAccessible: Optional[IntegerType]
    def numberOfServicesNotAccessed: Optional[IntegerType]
    def accessDetails: Optional[List[zio.aws.iam.model.AccessDetail.ReadOnly]]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[MarkerType]
    def errorDetails: Optional[zio.aws.iam.model.ErrorDetails.ReadOnly]
    def getJobStatus: ZIO[Any, Nothing, zio.aws.iam.model.JobStatusType] =
      ZIO.succeed(jobStatus)
    def getJobCreationDate: ZIO[Any, Nothing, DateType] =
      ZIO.succeed(jobCreationDate)
    def getJobCompletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("jobCompletionDate", jobCompletionDate)
    def getNumberOfServicesAccessible: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField(
        "numberOfServicesAccessible",
        numberOfServicesAccessible
      )
    def getNumberOfServicesNotAccessed: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField(
        "numberOfServicesNotAccessed",
        numberOfServicesNotAccessed
      )
    def getAccessDetails
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AccessDetail.ReadOnly]] =
      AwsError.unwrapOptionField("accessDetails", accessDetails)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getErrorDetails
        : ZIO[Any, AwsError, zio.aws.iam.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
  ) extends zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly {
    override val jobStatus: zio.aws.iam.model.JobStatusType =
      zio.aws.iam.model.JobStatusType.wrap(impl.jobStatus())
    override val jobCreationDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.jobCreationDate())
    override val jobCompletionDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.jobCompletionDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val numberOfServicesAccessible: Optional[IntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfServicesAccessible())
        .map(value => zio.aws.iam.model.primitives.IntegerType(value))
    override val numberOfServicesNotAccessed: Optional[IntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfServicesNotAccessed())
        .map(value => zio.aws.iam.model.primitives.IntegerType(value))
    override val accessDetails
        : Optional[List[zio.aws.iam.model.AccessDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.AccessDetail.wrap(item)
          }.toList
        )
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val errorDetails
        : Optional[zio.aws.iam.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.iam.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
  ): zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly =
    new Wrapper(impl)
}
