package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MarkerType,
  MaxItemsType,
  ServiceNamespaceType,
  JobIDType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetServiceLastAccessedDetailsWithEntitiesRequest(
    jobId: JobIDType,
    serviceNamespace: ServiceNamespaceType,
    maxItems: Optional[MaxItemsType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest = {
    import GetServiceLastAccessedDetailsWithEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
      .builder()
      .jobId(JobIDType.unwrap(jobId): java.lang.String)
      .serviceNamespace(
        ServiceNamespaceType.unwrap(serviceNamespace): java.lang.String
      )
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest.ReadOnly =
    zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
      .wrap(buildAwsValue())
}
object GetServiceLastAccessedDetailsWithEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest =
      zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest(
        jobId,
        serviceNamespace,
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def jobId: JobIDType
    def serviceNamespace: ServiceNamespaceType
    def maxItems: Optional[MaxItemsType]
    def marker: Optional[MarkerType]
    def getJobId: ZIO[Any, Nothing, JobIDType] = ZIO.succeed(jobId)
    def getServiceNamespace: ZIO[Any, Nothing, ServiceNamespaceType] =
      ZIO.succeed(serviceNamespace)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
  ) extends zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest.ReadOnly {
    override val jobId: JobIDType =
      zio.aws.iam.model.primitives.JobIDType(impl.jobId())
    override val serviceNamespace: ServiceNamespaceType =
      zio.aws.iam.model.primitives.ServiceNamespaceType(impl.serviceNamespace())
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
  ): zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest.ReadOnly =
    new Wrapper(impl)
}
