package zio.aws.iam.model
import zio.aws.iam.model.primitives.ExistingUserNameType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetUserRequest(
    userName: Optional[ExistingUserNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetUserRequest = {
    import GetUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetUserRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetUserRequest.ReadOnly =
    zio.aws.iam.model.GetUserRequest.wrap(buildAwsValue())
}
object GetUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetUserRequest =
      zio.aws.iam.model.GetUserRequest(userName.map(value => value))
    def userName: Optional[ExistingUserNameType]
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetUserRequest
  ) extends zio.aws.iam.model.GetUserRequest.ReadOnly {
    override val userName: Optional[ExistingUserNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userName())
        .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetUserRequest
  ): zio.aws.iam.model.GetUserRequest.ReadOnly = new Wrapper(impl)
}
