package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccountAliasesRequest(
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest = {
    import ListAccountAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest
      .builder()
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAccountAliasesRequest.ReadOnly =
    zio.aws.iam.model.ListAccountAliasesRequest.wrap(buildAwsValue())
}
object ListAccountAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAccountAliasesRequest =
      zio.aws.iam.model.ListAccountAliasesRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest
  ) extends zio.aws.iam.model.ListAccountAliasesRequest.ReadOnly {
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest
  ): zio.aws.iam.model.ListAccountAliasesRequest.ReadOnly = new Wrapper(impl)
}
