package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEntitiesForPolicyResponse(
    policyGroups: Optional[Iterable[zio.aws.iam.model.PolicyGroup]] =
      Optional.Absent,
    policyUsers: Optional[Iterable[zio.aws.iam.model.PolicyUser]] =
      Optional.Absent,
    policyRoles: Optional[Iterable[zio.aws.iam.model.PolicyRole]] =
      Optional.Absent,
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse = {
    import ListEntitiesForPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
      .builder()
      .optionallyWith(
        policyGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyGroups)
      .optionallyWith(
        policyUsers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyUsers)
      .optionallyWith(
        policyRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyRoles)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly =
    zio.aws.iam.model.ListEntitiesForPolicyResponse.wrap(buildAwsValue())
}
object ListEntitiesForPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListEntitiesForPolicyResponse =
      zio.aws.iam.model.ListEntitiesForPolicyResponse(
        policyGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policyUsers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policyRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def policyGroups: Optional[List[zio.aws.iam.model.PolicyGroup.ReadOnly]]
    def policyUsers: Optional[List[zio.aws.iam.model.PolicyUser.ReadOnly]]
    def policyRoles: Optional[List[zio.aws.iam.model.PolicyRole.ReadOnly]]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getPolicyGroups
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyGroup.ReadOnly]] =
      AwsError.unwrapOptionField("policyGroups", policyGroups)
    def getPolicyUsers
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyUser.ReadOnly]] =
      AwsError.unwrapOptionField("policyUsers", policyUsers)
    def getPolicyRoles
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyRole.ReadOnly]] =
      AwsError.unwrapOptionField("policyRoles", policyRoles)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
  ) extends zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly {
    override val policyGroups
        : Optional[List[zio.aws.iam.model.PolicyGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.PolicyGroup.wrap(item)
          }.toList
        )
    override val policyUsers
        : Optional[List[zio.aws.iam.model.PolicyUser.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyUsers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.PolicyUser.wrap(item)
          }.toList
        )
    override val policyRoles
        : Optional[List[zio.aws.iam.model.PolicyRole.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRoles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.PolicyRole.wrap(item)
          }.toList
        )
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
  ): zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
