package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, SerialNumberType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMfaDeviceTagsRequest(
    serialNumber: SerialNumberType,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest = {
    import ListMfaDeviceTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest
      .builder()
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListMfaDeviceTagsRequest.ReadOnly =
    zio.aws.iam.model.ListMfaDeviceTagsRequest.wrap(buildAwsValue())
}
object ListMfaDeviceTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListMfaDeviceTagsRequest =
      zio.aws.iam.model.ListMfaDeviceTagsRequest(
        serialNumber,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def serialNumber: SerialNumberType
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest
  ) extends zio.aws.iam.model.ListMfaDeviceTagsRequest.ReadOnly {
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest
  ): zio.aws.iam.model.ListMfaDeviceTagsRequest.ReadOnly = new Wrapper(impl)
}
