package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PolicyPathType,
  BooleanType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPoliciesRequest(
    scope: Optional[zio.aws.iam.model.PolicyScopeType] = Optional.Absent,
    onlyAttached: Optional[BooleanType] = Optional.Absent,
    pathPrefix: Optional[PolicyPathType] = Optional.Absent,
    policyUsageFilter: Optional[zio.aws.iam.model.PolicyUsageType] =
      Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPoliciesRequest
      .builder()
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        onlyAttached.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.onlyAttached)
      .optionallyWith(
        pathPrefix.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(policyUsageFilter.map(value => value.unwrap))(
        _.policyUsageFilter
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListPoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListPoliciesRequest.wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPoliciesRequest =
      zio.aws.iam.model.ListPoliciesRequest(
        scope.map(value => value),
        onlyAttached.map(value => value),
        pathPrefix.map(value => value),
        policyUsageFilter.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def scope: Optional[zio.aws.iam.model.PolicyScopeType]
    def onlyAttached: Optional[BooleanType]
    def pathPrefix: Optional[PolicyPathType]
    def policyUsageFilter: Optional[zio.aws.iam.model.PolicyUsageType]
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getScope: ZIO[Any, AwsError, zio.aws.iam.model.PolicyScopeType] =
      AwsError.unwrapOptionField("scope", scope)
    def getOnlyAttached: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("onlyAttached", onlyAttached)
    def getPathPrefix: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getPolicyUsageFilter
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicyUsageType] =
      AwsError.unwrapOptionField("policyUsageFilter", policyUsageFilter)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesRequest
  ) extends zio.aws.iam.model.ListPoliciesRequest.ReadOnly {
    override val scope: Optional[zio.aws.iam.model.PolicyScopeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.iam.model.PolicyScopeType.wrap(value))
    override val onlyAttached: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.onlyAttached())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val pathPrefix: Optional[PolicyPathType] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val policyUsageFilter
        : Optional[zio.aws.iam.model.PolicyUsageType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyUsageFilter())
      .map(value => zio.aws.iam.model.PolicyUsageType.wrap(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesRequest
  ): zio.aws.iam.model.ListPoliciesRequest.ReadOnly = new Wrapper(impl)
}
