package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  PolicyNameType,
  PolicyVersionIdType,
  AttachmentCountType,
  ArnType,
  BooleanType,
  IdType,
  DateType,
  PolicyPathType,
  PolicyDescriptionType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Policy(
    policyName: Optional[PolicyNameType] = Optional.Absent,
    policyId: Optional[IdType] = Optional.Absent,
    arn: Optional[ArnType] = Optional.Absent,
    path: Optional[PolicyPathType] = Optional.Absent,
    defaultVersionId: Optional[PolicyVersionIdType] = Optional.Absent,
    attachmentCount: Optional[AttachmentCountType] = Optional.Absent,
    permissionsBoundaryUsageCount: Optional[AttachmentCountType] =
      Optional.Absent,
    isAttachable: Optional[BooleanType] = Optional.Absent,
    description: Optional[PolicyDescriptionType] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent,
    updateDate: Optional[DateType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.Policy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyNameType.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        path.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        defaultVersionId.map(value =>
          PolicyVersionIdType.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        attachmentCount.map(value => AttachmentCountType.unwrap(value): Integer)
      )(_.attachmentCount)
      .optionallyWith(
        permissionsBoundaryUsageCount.map(value =>
          AttachmentCountType.unwrap(value): Integer
        )
      )(_.permissionsBoundaryUsageCount)
      .optionallyWith(
        isAttachable.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isAttachable)
      .optionallyWith(
        description.map(value =>
          PolicyDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(updateDate.map(value => DateType.unwrap(value): Instant))(
        _.updateDate
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.Policy.ReadOnly =
    zio.aws.iam.model.Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.Policy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.Policy = zio.aws.iam.model.Policy(
      policyName.map(value => value),
      policyId.map(value => value),
      arn.map(value => value),
      path.map(value => value),
      defaultVersionId.map(value => value),
      attachmentCount.map(value => value),
      permissionsBoundaryUsageCount.map(value => value),
      isAttachable.map(value => value),
      description.map(value => value),
      createDate.map(value => value),
      updateDate.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def policyName: Optional[PolicyNameType]
    def policyId: Optional[IdType]
    def arn: Optional[ArnType]
    def path: Optional[PolicyPathType]
    def defaultVersionId: Optional[PolicyVersionIdType]
    def attachmentCount: Optional[AttachmentCountType]
    def permissionsBoundaryUsageCount: Optional[AttachmentCountType]
    def isAttachable: Optional[BooleanType]
    def description: Optional[PolicyDescriptionType]
    def createDate: Optional[DateType]
    def updateDate: Optional[DateType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPolicyName: ZIO[Any, AwsError, PolicyNameType] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getPath: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("path", path)
    def getDefaultVersionId: ZIO[Any, AwsError, PolicyVersionIdType] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getAttachmentCount: ZIO[Any, AwsError, AttachmentCountType] =
      AwsError.unwrapOptionField("attachmentCount", attachmentCount)
    def getPermissionsBoundaryUsageCount
        : ZIO[Any, AwsError, AttachmentCountType] = AwsError.unwrapOptionField(
      "permissionsBoundaryUsageCount",
      permissionsBoundaryUsageCount
    )
    def getIsAttachable: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isAttachable", isAttachable)
    def getDescription: ZIO[Any, AwsError, PolicyDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getUpdateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("updateDate", updateDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.Policy
  ) extends zio.aws.iam.model.Policy.ReadOnly {
    override val policyName: Optional[PolicyNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iam.model.primitives.PolicyNameType(value))
    override val policyId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val path: Optional[PolicyPathType] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val defaultVersionId: Optional[PolicyVersionIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value => zio.aws.iam.model.primitives.PolicyVersionIdType(value))
    override val attachmentCount: Optional[AttachmentCountType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentCount())
        .map(value => zio.aws.iam.model.primitives.AttachmentCountType(value))
    override val permissionsBoundaryUsageCount: Optional[AttachmentCountType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsBoundaryUsageCount())
        .map(value => zio.aws.iam.model.primitives.AttachmentCountType(value))
    override val isAttachable: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isAttachable())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val description: Optional[PolicyDescriptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iam.model.primitives.PolicyDescriptionType(value))
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val updateDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.Policy
  ): zio.aws.iam.model.Policy.ReadOnly = new Wrapper(impl)
}
