package zio.aws.iam.model
import zio.aws.iam.model.primitives.{CertificateChainType, CertificateBodyType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServerCertificate(
    serverCertificateMetadata: zio.aws.iam.model.ServerCertificateMetadata,
    certificateBody: CertificateBodyType,
    certificateChain: Optional[CertificateChainType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ServerCertificate = {
    import ServerCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ServerCertificate
      .builder()
      .serverCertificateMetadata(serverCertificateMetadata.buildAwsValue())
      .certificateBody(
        CertificateBodyType.unwrap(certificateBody): java.lang.String
      )
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChainType.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ServerCertificate.ReadOnly =
    zio.aws.iam.model.ServerCertificate.wrap(buildAwsValue())
}
object ServerCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ServerCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ServerCertificate =
      zio.aws.iam.model.ServerCertificate(
        serverCertificateMetadata.asEditable,
        certificateBody,
        certificateChain.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverCertificateMetadata
        : zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
    def certificateBody: CertificateBodyType
    def certificateChain: Optional[CertificateChainType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getServerCertificateMetadata: ZIO[
      Any,
      Nothing,
      zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
    ] = ZIO.succeed(serverCertificateMetadata)
    def getCertificateBody: ZIO[Any, Nothing, CertificateBodyType] =
      ZIO.succeed(certificateBody)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainType] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ServerCertificate
  ) extends zio.aws.iam.model.ServerCertificate.ReadOnly {
    override val serverCertificateMetadata
        : zio.aws.iam.model.ServerCertificateMetadata.ReadOnly =
      zio.aws.iam.model.ServerCertificateMetadata
        .wrap(impl.serverCertificateMetadata())
    override val certificateBody: CertificateBodyType =
      zio.aws.iam.model.primitives.CertificateBodyType(impl.certificateBody())
    override val certificateChain: Optional[CertificateChainType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateChain())
        .map(value => zio.aws.iam.model.primitives.CertificateChainType(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ServerCertificate
  ): zio.aws.iam.model.ServerCertificate.ReadOnly = new Wrapper(impl)
}
