package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagSamlProviderRequest(
    samlProviderArn: ArnType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagSamlProviderRequest = {
    import TagSamlProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagSamlProviderRequest
      .builder()
      .samlProviderArn(ArnType.unwrap(samlProviderArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagSamlProviderRequest.ReadOnly =
    zio.aws.iam.model.TagSamlProviderRequest.wrap(buildAwsValue())
}
object TagSamlProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagSamlProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagSamlProviderRequest =
      zio.aws.iam.model.TagSamlProviderRequest(
        samlProviderArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def samlProviderArn: ArnType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getSamlProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(samlProviderArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagSamlProviderRequest
  ) extends zio.aws.iam.model.TagSamlProviderRequest.ReadOnly {
    override val samlProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.samlProviderArn())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagSamlProviderRequest
  ): zio.aws.iam.model.TagSamlProviderRequest.ReadOnly = new Wrapper(impl)
}
