package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ServiceSpecificCredentialId, UserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceSpecificCredentialRequest(
    userName: Optional[UserNameType] = Optional.Absent,
    serviceSpecificCredentialId: ServiceSpecificCredentialId,
    status: zio.aws.iam.model.StatusType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest = {
    import UpdateServiceSpecificCredentialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .serviceSpecificCredentialId(
        ServiceSpecificCredentialId.unwrap(
          serviceSpecificCredentialId
        ): java.lang.String
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.UpdateServiceSpecificCredentialRequest.ReadOnly =
    zio.aws.iam.model.UpdateServiceSpecificCredentialRequest
      .wrap(buildAwsValue())
}
object UpdateServiceSpecificCredentialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateServiceSpecificCredentialRequest =
      zio.aws.iam.model.UpdateServiceSpecificCredentialRequest(
        userName.map(value => value),
        serviceSpecificCredentialId,
        status
      )
    def userName: Optional[UserNameType]
    def serviceSpecificCredentialId: ServiceSpecificCredentialId
    def status: zio.aws.iam.model.StatusType
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getServiceSpecificCredentialId
        : ZIO[Any, Nothing, ServiceSpecificCredentialId] =
      ZIO.succeed(serviceSpecificCredentialId)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest
  ) extends zio.aws.iam.model.UpdateServiceSpecificCredentialRequest.ReadOnly {
    override val userName: Optional[UserNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val serviceSpecificCredentialId: ServiceSpecificCredentialId =
      zio.aws.iam.model.primitives
        .ServiceSpecificCredentialId(impl.serviceSpecificCredentialId())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest
  ): zio.aws.iam.model.UpdateServiceSpecificCredentialRequest.ReadOnly =
    new Wrapper(impl)
}
