package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UploadSigningCertificateResponse(
    certificate: zio.aws.iam.model.SigningCertificate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse = {
    import UploadSigningCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse
      .builder()
      .certificate(certificate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly =
    zio.aws.iam.model.UploadSigningCertificateResponse.wrap(buildAwsValue())
}
object UploadSigningCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadSigningCertificateResponse =
      zio.aws.iam.model.UploadSigningCertificateResponse(certificate.asEditable)
    def certificate: zio.aws.iam.model.SigningCertificate.ReadOnly
    def getCertificate
        : ZIO[Any, Nothing, zio.aws.iam.model.SigningCertificate.ReadOnly] =
      ZIO.succeed(certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse
  ) extends zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly {
    override val certificate: zio.aws.iam.model.SigningCertificate.ReadOnly =
      zio.aws.iam.model.SigningCertificate.wrap(impl.certificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse
  ): zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
