package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ClientIDType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddClientIdToOpenIdConnectProviderRequest(
    openIDConnectProviderArn: ArnType,
    clientID: ClientIDType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest = {
    import AddClientIdToOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .clientID(ClientIDType.unwrap(clientID): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest
      .wrap(buildAwsValue())
}
object AddClientIdToOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest =
      zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest(
        openIDConnectProviderArn,
        clientID
      )
    def openIDConnectProviderArn: ArnType
    def clientID: ClientIDType
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
    def getClientID: ZIO[Any, Nothing, ClientIDType] = ZIO.succeed(clientID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
    override val clientID: ClientIDType =
      zio.aws.iam.model.primitives.ClientIDType(impl.clientID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest
  ): zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest.ReadOnly =
    new Wrapper(impl)
}
