package zio.aws.iam.model
import zio.aws.iam.model.primitives.{RoleNameType, InstanceProfileNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddRoleToInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType,
    roleName: RoleNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest = {
    import AddRoleToInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AddRoleToInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.AddRoleToInstanceProfileRequest.wrap(buildAwsValue())
}
object AddRoleToInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AddRoleToInstanceProfileRequest =
      zio.aws.iam.model
        .AddRoleToInstanceProfileRequest(instanceProfileName, roleName)
    def instanceProfileName: InstanceProfileNameType
    def roleName: RoleNameType
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest
  ) extends zio.aws.iam.model.AddRoleToInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest
  ): zio.aws.iam.model.AddRoleToInstanceProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
