package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ExistingUserNameType, GroupNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddUserToGroupRequest(
    groupName: GroupNameType,
    userName: ExistingUserNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AddUserToGroupRequest = {
    import AddUserToGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AddUserToGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AddUserToGroupRequest.ReadOnly =
    zio.aws.iam.model.AddUserToGroupRequest.wrap(buildAwsValue())
}
object AddUserToGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AddUserToGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AddUserToGroupRequest =
      zio.aws.iam.model.AddUserToGroupRequest(groupName, userName)
    def groupName: GroupNameType
    def userName: ExistingUserNameType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AddUserToGroupRequest
  ) extends zio.aws.iam.model.AddUserToGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AddUserToGroupRequest
  ): zio.aws.iam.model.AddUserToGroupRequest.ReadOnly = new Wrapper(impl)
}
