package zio.aws.iam.model
import zio.aws.iam.model.primitives.ExistingUserNameType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAccessKeyRequest(
    userName: Optional[ExistingUserNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest = {
    import CreateAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateAccessKeyRequest.ReadOnly =
    zio.aws.iam.model.CreateAccessKeyRequest.wrap(buildAwsValue())
}
object CreateAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateAccessKeyRequest =
      zio.aws.iam.model.CreateAccessKeyRequest(userName.map(value => value))
    def userName: Optional[ExistingUserNameType]
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest
  ) extends zio.aws.iam.model.CreateAccessKeyRequest.ReadOnly {
    override val userName: Optional[ExistingUserNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userName())
        .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest
  ): zio.aws.iam.model.CreateAccessKeyRequest.ReadOnly = new Wrapper(impl)
}
