package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateInstanceProfileResponse(
    instanceProfile: zio.aws.iam.model.InstanceProfile
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse = {
    import CreateInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse
      .builder()
      .instanceProfile(instanceProfile.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly =
    zio.aws.iam.model.CreateInstanceProfileResponse.wrap(buildAwsValue())
}
object CreateInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateInstanceProfileResponse =
      zio.aws.iam.model
        .CreateInstanceProfileResponse(instanceProfile.asEditable)
    def instanceProfile: zio.aws.iam.model.InstanceProfile.ReadOnly
    def getInstanceProfile
        : ZIO[Any, Nothing, zio.aws.iam.model.InstanceProfile.ReadOnly] =
      ZIO.succeed(instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse
  ) extends zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly {
    override val instanceProfile: zio.aws.iam.model.InstanceProfile.ReadOnly =
      zio.aws.iam.model.InstanceProfile.wrap(impl.instanceProfile())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse
  ): zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
