package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ThumbprintType,
  ClientIDType,
  OpenIDConnectProviderUrlType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateOpenIdConnectProviderRequest(
    url: OpenIDConnectProviderUrlType,
    clientIDList: Optional[Iterable[ClientIDType]] = Optional.Absent,
    thumbprintList: Iterable[ThumbprintType],
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest = {
    import CreateOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest
      .builder()
      .url(OpenIDConnectProviderUrlType.unwrap(url): java.lang.String)
      .optionallyWith(
        clientIDList.map(value =>
          value.map { item =>
            ClientIDType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientIDList)
      .thumbprintList(thumbprintList.map { item =>
        ThumbprintType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.CreateOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.CreateOpenIdConnectProviderRequest.wrap(buildAwsValue())
}
object CreateOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateOpenIdConnectProviderRequest =
      zio.aws.iam.model.CreateOpenIdConnectProviderRequest(
        url,
        clientIDList.map(value => value),
        thumbprintList,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def url: OpenIDConnectProviderUrlType
    def clientIDList: Optional[List[ClientIDType]]
    def thumbprintList: List[ThumbprintType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getUrl: ZIO[Any, Nothing, OpenIDConnectProviderUrlType] =
      ZIO.succeed(url)
    def getClientIDList: ZIO[Any, AwsError, List[ClientIDType]] =
      AwsError.unwrapOptionField("clientIDList", clientIDList)
    def getThumbprintList: ZIO[Any, Nothing, List[ThumbprintType]] =
      ZIO.succeed(thumbprintList)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.CreateOpenIdConnectProviderRequest.ReadOnly {
    override val url: OpenIDConnectProviderUrlType =
      zio.aws.iam.model.primitives.OpenIDConnectProviderUrlType(impl.url())
    override val clientIDList: Optional[List[ClientIDType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientIDList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.ClientIDType(item)
          }.toList
        )
    override val thumbprintList: List[ThumbprintType] = impl
      .thumbprintList()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.ThumbprintType(item)
      }
      .toList
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest
  ): zio.aws.iam.model.CreateOpenIdConnectProviderRequest.ReadOnly =
    new Wrapper(impl)
}
