package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateRoleResponse(role: zio.aws.iam.model.Role) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateRoleResponse = {
    import CreateRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateRoleResponse
      .builder()
      .role(role.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateRoleResponse.ReadOnly =
    zio.aws.iam.model.CreateRoleResponse.wrap(buildAwsValue())
}
object CreateRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateRoleResponse =
      zio.aws.iam.model.CreateRoleResponse(role.asEditable)
    def role: zio.aws.iam.model.Role.ReadOnly
    def getRole: ZIO[Any, Nothing, zio.aws.iam.model.Role.ReadOnly] =
      ZIO.succeed(role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateRoleResponse
  ) extends zio.aws.iam.model.CreateRoleResponse.ReadOnly {
    override val role: zio.aws.iam.model.Role.ReadOnly =
      zio.aws.iam.model.Role.wrap(impl.role())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateRoleResponse
  ): zio.aws.iam.model.CreateRoleResponse.ReadOnly = new Wrapper(impl)
}
