package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  CustomSuffixType,
  RoleDescriptionType,
  GroupNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceLinkedRoleRequest(
    awsServiceName: GroupNameType,
    description: Optional[RoleDescriptionType] = Optional.Absent,
    customSuffix: Optional[CustomSuffixType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest = {
    import CreateServiceLinkedRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest
      .builder()
      .awsServiceName(GroupNameType.unwrap(awsServiceName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RoleDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        customSuffix.map(value =>
          CustomSuffixType.unwrap(value): java.lang.String
        )
      )(_.customSuffix)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateServiceLinkedRoleRequest.ReadOnly =
    zio.aws.iam.model.CreateServiceLinkedRoleRequest.wrap(buildAwsValue())
}
object CreateServiceLinkedRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateServiceLinkedRoleRequest =
      zio.aws.iam.model.CreateServiceLinkedRoleRequest(
        awsServiceName,
        description.map(value => value),
        customSuffix.map(value => value)
      )
    def awsServiceName: GroupNameType
    def description: Optional[RoleDescriptionType]
    def customSuffix: Optional[CustomSuffixType]
    def getAwsServiceName: ZIO[Any, Nothing, GroupNameType] =
      ZIO.succeed(awsServiceName)
    def getDescription: ZIO[Any, AwsError, RoleDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getCustomSuffix: ZIO[Any, AwsError, CustomSuffixType] =
      AwsError.unwrapOptionField("customSuffix", customSuffix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest
  ) extends zio.aws.iam.model.CreateServiceLinkedRoleRequest.ReadOnly {
    override val awsServiceName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.awsServiceName())
    override val description: Optional[RoleDescriptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iam.model.primitives.RoleDescriptionType(value))
    override val customSuffix: Optional[CustomSuffixType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customSuffix())
        .map(value => zio.aws.iam.model.primitives.CustomSuffixType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest
  ): zio.aws.iam.model.CreateServiceLinkedRoleRequest.ReadOnly = new Wrapper(
    impl
  )
}
