package zio.aws.iam.model
import zio.aws.iam.model.primitives.AccountAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAccountAliasRequest(accountAlias: AccountAliasType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest = {
    import DeleteAccountAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest
      .builder()
      .accountAlias(AccountAliasType.unwrap(accountAlias): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteAccountAliasRequest.ReadOnly =
    zio.aws.iam.model.DeleteAccountAliasRequest.wrap(buildAwsValue())
}
object DeleteAccountAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteAccountAliasRequest =
      zio.aws.iam.model.DeleteAccountAliasRequest(accountAlias)
    def accountAlias: AccountAliasType
    def getAccountAlias: ZIO[Any, Nothing, AccountAliasType] =
      ZIO.succeed(accountAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest
  ) extends zio.aws.iam.model.DeleteAccountAliasRequest.ReadOnly {
    override val accountAlias: AccountAliasType =
      zio.aws.iam.model.primitives.AccountAliasType(impl.accountAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest
  ): zio.aws.iam.model.DeleteAccountAliasRequest.ReadOnly = new Wrapper(impl)
}
