package zio.aws.iam.model
import zio.aws.iam.model.primitives.GroupNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGroupRequest(groupName: GroupNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteGroupRequest = {
    import DeleteGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteGroupRequest.ReadOnly =
    zio.aws.iam.model.DeleteGroupRequest.wrap(buildAwsValue())
}
object DeleteGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteGroupRequest =
      zio.aws.iam.model.DeleteGroupRequest(groupName)
    def groupName: GroupNameType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteGroupRequest
  ) extends zio.aws.iam.model.DeleteGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteGroupRequest
  ): zio.aws.iam.model.DeleteGroupRequest.ReadOnly = new Wrapper(impl)
}
