package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyVersionIdType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePolicyVersionRequest(
    policyArn: ArnType,
    versionId: PolicyVersionIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest = {
    import DeletePolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .versionId(PolicyVersionIdType.unwrap(versionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeletePolicyVersionRequest.ReadOnly =
    zio.aws.iam.model.DeletePolicyVersionRequest.wrap(buildAwsValue())
}
object DeletePolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeletePolicyVersionRequest =
      zio.aws.iam.model.DeletePolicyVersionRequest(policyArn, versionId)
    def policyArn: ArnType
    def versionId: PolicyVersionIdType
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getVersionId: ZIO[Any, Nothing, PolicyVersionIdType] =
      ZIO.succeed(versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest
  ) extends zio.aws.iam.model.DeletePolicyVersionRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val versionId: PolicyVersionIdType =
      zio.aws.iam.model.primitives.PolicyVersionIdType(impl.versionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest
  ): zio.aws.iam.model.DeletePolicyVersionRequest.ReadOnly = new Wrapper(impl)
}
