package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyNameType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRolePolicyRequest(
    roleName: RoleNameType,
    policyName: PolicyNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest = {
    import DeleteRolePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteRolePolicyRequest.ReadOnly =
    zio.aws.iam.model.DeleteRolePolicyRequest.wrap(buildAwsValue())
}
object DeleteRolePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteRolePolicyRequest =
      zio.aws.iam.model.DeleteRolePolicyRequest(roleName, policyName)
    def roleName: RoleNameType
    def policyName: PolicyNameType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest
  ) extends zio.aws.iam.model.DeleteRolePolicyRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest
  ): zio.aws.iam.model.DeleteRolePolicyRequest.ReadOnly = new Wrapper(impl)
}
