package zio.aws.iam.model
import zio.aws.iam.model.primitives.RoleNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRoleRequest(roleName: RoleNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteRoleRequest = {
    import DeleteRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteRoleRequest.ReadOnly =
    zio.aws.iam.model.DeleteRoleRequest.wrap(buildAwsValue())
}
object DeleteRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteRoleRequest =
      zio.aws.iam.model.DeleteRoleRequest(roleName)
    def roleName: RoleNameType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteRoleRequest
  ) extends zio.aws.iam.model.DeleteRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteRoleRequest
  ): zio.aws.iam.model.DeleteRoleRequest.ReadOnly = new Wrapper(impl)
}
