package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSamlProviderRequest(samlProviderArn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest = {
    import DeleteSamlProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest
      .builder()
      .samlProviderArn(ArnType.unwrap(samlProviderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteSamlProviderRequest.ReadOnly =
    zio.aws.iam.model.DeleteSamlProviderRequest.wrap(buildAwsValue())
}
object DeleteSamlProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteSamlProviderRequest =
      zio.aws.iam.model.DeleteSamlProviderRequest(samlProviderArn)
    def samlProviderArn: ArnType
    def getSamlProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(samlProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest
  ) extends zio.aws.iam.model.DeleteSamlProviderRequest.ReadOnly {
    override val samlProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.samlProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest
  ): zio.aws.iam.model.DeleteSamlProviderRequest.ReadOnly = new Wrapper(impl)
}
