package zio.aws.iam.model
import zio.aws.iam.model.primitives.ServerCertificateNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServerCertificateRequest(
    serverCertificateName: ServerCertificateNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest = {
    import DeleteServerCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest
      .builder()
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteServerCertificateRequest.ReadOnly =
    zio.aws.iam.model.DeleteServerCertificateRequest.wrap(buildAwsValue())
}
object DeleteServerCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteServerCertificateRequest =
      zio.aws.iam.model.DeleteServerCertificateRequest(serverCertificateName)
    def serverCertificateName: ServerCertificateNameType
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest
  ) extends zio.aws.iam.model.DeleteServerCertificateRequest.ReadOnly {
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest
  ): zio.aws.iam.model.DeleteServerCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
