package zio.aws.iam.model
import zio.aws.iam.model.primitives.DeletionTaskIdType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceLinkedRoleResponse(
    deletionTaskId: DeletionTaskIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse = {
    import DeleteServiceLinkedRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse
      .builder()
      .deletionTaskId(
        DeletionTaskIdType.unwrap(deletionTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly =
    zio.aws.iam.model.DeleteServiceLinkedRoleResponse.wrap(buildAwsValue())
}
object DeleteServiceLinkedRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteServiceLinkedRoleResponse =
      zio.aws.iam.model.DeleteServiceLinkedRoleResponse(deletionTaskId)
    def deletionTaskId: DeletionTaskIdType
    def getDeletionTaskId: ZIO[Any, Nothing, DeletionTaskIdType] =
      ZIO.succeed(deletionTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse
  ) extends zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly {
    override val deletionTaskId: DeletionTaskIdType =
      zio.aws.iam.model.primitives.DeletionTaskIdType(impl.deletionTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse
  ): zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly = new Wrapper(
    impl
  )
}
