package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PublicKeyIdType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSshPublicKeyRequest(
    userName: UserNameType,
    sshPublicKeyId: PublicKeyIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest = {
    import DeleteSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .sshPublicKeyId(PublicKeyIdType.unwrap(sshPublicKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteSshPublicKeyRequest.ReadOnly =
    zio.aws.iam.model.DeleteSshPublicKeyRequest.wrap(buildAwsValue())
}
object DeleteSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteSshPublicKeyRequest =
      zio.aws.iam.model.DeleteSshPublicKeyRequest(userName, sshPublicKeyId)
    def userName: UserNameType
    def sshPublicKeyId: PublicKeyIdType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSshPublicKeyId: ZIO[Any, Nothing, PublicKeyIdType] =
      ZIO.succeed(sshPublicKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest
  ) extends zio.aws.iam.model.DeleteSshPublicKeyRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val sshPublicKeyId: PublicKeyIdType =
      zio.aws.iam.model.primitives.PublicKeyIdType(impl.sshPublicKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest
  ): zio.aws.iam.model.DeleteSshPublicKeyRequest.ReadOnly = new Wrapper(impl)
}
