package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyNameType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUserPolicyRequest(
    userName: ExistingUserNameType,
    policyName: PolicyNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest = {
    import DeleteUserPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteUserPolicyRequest.ReadOnly =
    zio.aws.iam.model.DeleteUserPolicyRequest.wrap(buildAwsValue())
}
object DeleteUserPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteUserPolicyRequest =
      zio.aws.iam.model.DeleteUserPolicyRequest(userName, policyName)
    def userName: ExistingUserNameType
    def policyName: PolicyNameType
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest
  ) extends zio.aws.iam.model.DeleteUserPolicyRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest
  ): zio.aws.iam.model.DeleteUserPolicyRequest.ReadOnly = new Wrapper(impl)
}
