package zio.aws.iam.model
import zio.aws.iam.model.primitives.ReasonType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeletionTaskFailureReasonType(
    reason: Optional[ReasonType] = Optional.Absent,
    roleUsageList: Optional[Iterable[zio.aws.iam.model.RoleUsageType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeletionTaskFailureReasonType = {
    import DeletionTaskFailureReasonType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeletionTaskFailureReasonType
      .builder()
      .optionallyWith(
        reason.map(value => ReasonType.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        roleUsageList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roleUsageList)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeletionTaskFailureReasonType.ReadOnly =
    zio.aws.iam.model.DeletionTaskFailureReasonType.wrap(buildAwsValue())
}
object DeletionTaskFailureReasonType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeletionTaskFailureReasonType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeletionTaskFailureReasonType =
      zio.aws.iam.model.DeletionTaskFailureReasonType(
        reason.map(value => value),
        roleUsageList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reason: Optional[ReasonType]
    def roleUsageList: Optional[List[zio.aws.iam.model.RoleUsageType.ReadOnly]]
    def getReason: ZIO[Any, AwsError, ReasonType] =
      AwsError.unwrapOptionField("reason", reason)
    def getRoleUsageList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.RoleUsageType.ReadOnly]] =
      AwsError.unwrapOptionField("roleUsageList", roleUsageList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeletionTaskFailureReasonType
  ) extends zio.aws.iam.model.DeletionTaskFailureReasonType.ReadOnly {
    override val reason: Optional[ReasonType] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.iam.model.primitives.ReasonType(value))
    override val roleUsageList
        : Optional[List[zio.aws.iam.model.RoleUsageType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleUsageList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.RoleUsageType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeletionTaskFailureReasonType
  ): zio.aws.iam.model.DeletionTaskFailureReasonType.ReadOnly = new Wrapper(
    impl
  )
}
