package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, GroupNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachGroupPolicyRequest(
    groupName: GroupNameType,
    policyArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest = {
    import DetachGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DetachGroupPolicyRequest.ReadOnly =
    zio.aws.iam.model.DetachGroupPolicyRequest.wrap(buildAwsValue())
}
object DetachGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DetachGroupPolicyRequest =
      zio.aws.iam.model.DetachGroupPolicyRequest(groupName, policyArn)
    def groupName: GroupNameType
    def policyArn: ArnType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest
  ) extends zio.aws.iam.model.DetachGroupPolicyRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest
  ): zio.aws.iam.model.DetachGroupPolicyRequest.ReadOnly = new Wrapper(impl)
}
