package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachRolePolicyRequest(
    roleName: RoleNameType,
    policyArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest = {
    import DetachRolePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DetachRolePolicyRequest.ReadOnly =
    zio.aws.iam.model.DetachRolePolicyRequest.wrap(buildAwsValue())
}
object DetachRolePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DetachRolePolicyRequest =
      zio.aws.iam.model.DetachRolePolicyRequest(roleName, policyArn)
    def roleName: RoleNameType
    def policyArn: ArnType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest
  ) extends zio.aws.iam.model.DetachRolePolicyRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest
  ): zio.aws.iam.model.DetachRolePolicyRequest.ReadOnly = new Wrapper(impl)
}
