package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachUserPolicyRequest(
    userName: UserNameType,
    policyArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest = {
    import DetachUserPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DetachUserPolicyRequest.ReadOnly =
    zio.aws.iam.model.DetachUserPolicyRequest.wrap(buildAwsValue())
}
object DetachUserPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DetachUserPolicyRequest =
      zio.aws.iam.model.DetachUserPolicyRequest(userName, policyArn)
    def userName: UserNameType
    def policyArn: ArnType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest
  ) extends zio.aws.iam.model.DetachUserPolicyRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest
  ): zio.aws.iam.model.DetachUserPolicyRequest.ReadOnly = new Wrapper(impl)
}
