package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait EncodingType {
  def unwrap: software.amazon.awssdk.services.iam.model.EncodingType
}
object EncodingType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.EncodingType
  ): zio.aws.iam.model.EncodingType = value match {
    case software.amazon.awssdk.services.iam.model.EncodingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.EncodingType.SSH =>
      val r = SSH
      r
    case software.amazon.awssdk.services.iam.model.EncodingType.PEM =>
      val r = PEM
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.EncodingType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.EncodingType =
      software.amazon.awssdk.services.iam.model.EncodingType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSH extends zio.aws.iam.model.EncodingType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.EncodingType =
      software.amazon.awssdk.services.iam.model.EncodingType.SSH
  }
  case object PEM extends zio.aws.iam.model.EncodingType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.EncodingType =
      software.amazon.awssdk.services.iam.model.EncodingType.PEM
  }
}
