package zio.aws.iam.model
import zio.aws.iam.model.primitives.ReportStateDescriptionType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GenerateCredentialReportResponse(
    state: Optional[zio.aws.iam.model.ReportStateType] = Optional.Absent,
    description: Optional[ReportStateDescriptionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse = {
    import GenerateCredentialReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          ReportStateDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly =
    zio.aws.iam.model.GenerateCredentialReportResponse.wrap(buildAwsValue())
}
object GenerateCredentialReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GenerateCredentialReportResponse =
      zio.aws.iam.model.GenerateCredentialReportResponse(
        state.map(value => value),
        description.map(value => value)
      )
    def state: Optional[zio.aws.iam.model.ReportStateType]
    def description: Optional[ReportStateDescriptionType]
    def getState: ZIO[Any, AwsError, zio.aws.iam.model.ReportStateType] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, ReportStateDescriptionType] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse
  ) extends zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly {
    override val state: Optional[zio.aws.iam.model.ReportStateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iam.model.ReportStateType.wrap(value))
    override val description: Optional[ReportStateDescriptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.iam.model.primitives.ReportStateDescriptionType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse
  ): zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly = new Wrapper(
    impl
  )
}
