package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  OrganizationsPolicyIdType,
  OrganizationsEntityPathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GenerateOrganizationsAccessReportRequest(
    entityPath: OrganizationsEntityPathType,
    organizationsPolicyId: Optional[OrganizationsPolicyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest = {
    import GenerateOrganizationsAccessReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
      .builder()
      .entityPath(
        OrganizationsEntityPathType.unwrap(entityPath): java.lang.String
      )
      .optionallyWith(
        organizationsPolicyId.map(value =>
          OrganizationsPolicyIdType.unwrap(value): java.lang.String
        )
      )(_.organizationsPolicyId)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GenerateOrganizationsAccessReportRequest.ReadOnly =
    zio.aws.iam.model.GenerateOrganizationsAccessReportRequest
      .wrap(buildAwsValue())
}
object GenerateOrganizationsAccessReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GenerateOrganizationsAccessReportRequest =
      zio.aws.iam.model.GenerateOrganizationsAccessReportRequest(
        entityPath,
        organizationsPolicyId.map(value => value)
      )
    def entityPath: OrganizationsEntityPathType
    def organizationsPolicyId: Optional[OrganizationsPolicyIdType]
    def getEntityPath: ZIO[Any, Nothing, OrganizationsEntityPathType] =
      ZIO.succeed(entityPath)
    def getOrganizationsPolicyId
        : ZIO[Any, AwsError, OrganizationsPolicyIdType] =
      AwsError.unwrapOptionField("organizationsPolicyId", organizationsPolicyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
  ) extends zio.aws.iam.model.GenerateOrganizationsAccessReportRequest.ReadOnly {
    override val entityPath: OrganizationsEntityPathType =
      zio.aws.iam.model.primitives
        .OrganizationsEntityPathType(impl.entityPath())
    override val organizationsPolicyId: Optional[OrganizationsPolicyIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationsPolicyId())
        .map(value =>
          zio.aws.iam.model.primitives.OrganizationsPolicyIdType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
  ): zio.aws.iam.model.GenerateOrganizationsAccessReportRequest.ReadOnly =
    new Wrapper(impl)
}
