package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccountAuthorizationDetailsResponse(
    userDetailList: Optional[Iterable[zio.aws.iam.model.UserDetail]] =
      Optional.Absent,
    groupDetailList: Optional[Iterable[zio.aws.iam.model.GroupDetail]] =
      Optional.Absent,
    roleDetailList: Optional[Iterable[zio.aws.iam.model.RoleDetail]] =
      Optional.Absent,
    policies: Optional[Iterable[zio.aws.iam.model.ManagedPolicyDetail]] =
      Optional.Absent,
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse = {
    import GetAccountAuthorizationDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse
      .builder()
      .optionallyWith(
        userDetailList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userDetailList)
      .optionallyWith(
        groupDetailList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupDetailList)
      .optionallyWith(
        roleDetailList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roleDetailList)
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly =
    zio.aws.iam.model.GetAccountAuthorizationDetailsResponse
      .wrap(buildAwsValue())
}
object GetAccountAuthorizationDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccountAuthorizationDetailsResponse =
      zio.aws.iam.model.GetAccountAuthorizationDetailsResponse(
        userDetailList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupDetailList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleDetailList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def userDetailList: Optional[List[zio.aws.iam.model.UserDetail.ReadOnly]]
    def groupDetailList: Optional[List[zio.aws.iam.model.GroupDetail.ReadOnly]]
    def roleDetailList: Optional[List[zio.aws.iam.model.RoleDetail.ReadOnly]]
    def policies: Optional[List[zio.aws.iam.model.ManagedPolicyDetail.ReadOnly]]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getUserDetailList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.UserDetail.ReadOnly]] =
      AwsError.unwrapOptionField("userDetailList", userDetailList)
    def getGroupDetailList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.GroupDetail.ReadOnly]] =
      AwsError.unwrapOptionField("groupDetailList", groupDetailList)
    def getRoleDetailList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.RoleDetail.ReadOnly]] =
      AwsError.unwrapOptionField("roleDetailList", roleDetailList)
    def getPolicies: ZIO[Any, AwsError, List[
      zio.aws.iam.model.ManagedPolicyDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policies)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse
  ) extends zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly {
    override val userDetailList
        : Optional[List[zio.aws.iam.model.UserDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDetailList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.UserDetail.wrap(item)
          }.toList
        )
    override val groupDetailList
        : Optional[List[zio.aws.iam.model.GroupDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupDetailList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.GroupDetail.wrap(item)
          }.toList
        )
    override val roleDetailList
        : Optional[List[zio.aws.iam.model.RoleDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleDetailList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.RoleDetail.wrap(item)
          }.toList
        )
    override val policies
        : Optional[List[zio.aws.iam.model.ManagedPolicyDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.ManagedPolicyDetail.wrap(item)
          }.toList
        )
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse
  ): zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
