package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAccountPasswordPolicyResponse(
    passwordPolicy: zio.aws.iam.model.PasswordPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse = {
    import GetAccountPasswordPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse
      .builder()
      .passwordPolicy(passwordPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly =
    zio.aws.iam.model.GetAccountPasswordPolicyResponse.wrap(buildAwsValue())
}
object GetAccountPasswordPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccountPasswordPolicyResponse =
      zio.aws.iam.model
        .GetAccountPasswordPolicyResponse(passwordPolicy.asEditable)
    def passwordPolicy: zio.aws.iam.model.PasswordPolicy.ReadOnly
    def getPasswordPolicy
        : ZIO[Any, Nothing, zio.aws.iam.model.PasswordPolicy.ReadOnly] =
      ZIO.succeed(passwordPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse
  ) extends zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly {
    override val passwordPolicy: zio.aws.iam.model.PasswordPolicy.ReadOnly =
      zio.aws.iam.model.PasswordPolicy.wrap(impl.passwordPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse
  ): zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
