package zio.aws.iam.model
import zio.aws.iam.model.primitives.UserNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLoginProfileRequest(userName: UserNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetLoginProfileRequest = {
    import GetLoginProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetLoginProfileRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetLoginProfileRequest.ReadOnly =
    zio.aws.iam.model.GetLoginProfileRequest.wrap(buildAwsValue())
}
object GetLoginProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetLoginProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetLoginProfileRequest =
      zio.aws.iam.model.GetLoginProfileRequest(userName)
    def userName: UserNameType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetLoginProfileRequest
  ) extends zio.aws.iam.model.GetLoginProfileRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetLoginProfileRequest
  ): zio.aws.iam.model.GetLoginProfileRequest.ReadOnly = new Wrapper(impl)
}
