package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait GlobalEndpointTokenVersion {
  def unwrap
      : software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion
}
object GlobalEndpointTokenVersion {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion
  ): zio.aws.iam.model.GlobalEndpointTokenVersion = value match {
    case software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion.V1_TOKEN =>
      val r = v1Token
      r
    case software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion.V2_TOKEN =>
      val r = v2Token
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iam.model.GlobalEndpointTokenVersion {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion =
      software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object v1Token extends zio.aws.iam.model.GlobalEndpointTokenVersion {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion =
      software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion.V1_TOKEN
  }
  case object v2Token extends zio.aws.iam.model.GlobalEndpointTokenVersion {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion =
      software.amazon.awssdk.services.iam.model.GlobalEndpointTokenVersion.V2_TOKEN
  }
}
