package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  GroupNameType,
  PathType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Group(
    path: PathType,
    groupName: GroupNameType,
    groupId: IdType,
    arn: ArnType,
    createDate: DateType
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.Group
      .builder()
      .path(PathType.unwrap(path): java.lang.String)
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .groupId(IdType.unwrap(groupId): java.lang.String)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .createDate(DateType.unwrap(createDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.Group.ReadOnly =
    zio.aws.iam.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.Group] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.Group =
      zio.aws.iam.model.Group(path, groupName, groupId, arn, createDate)
    def path: PathType
    def groupName: GroupNameType
    def groupId: IdType
    def arn: ArnType
    def createDate: DateType
    def getPath: ZIO[Any, Nothing, PathType] = ZIO.succeed(path)
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getGroupId: ZIO[Any, Nothing, IdType] = ZIO.succeed(groupId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.Group
  ) extends zio.aws.iam.model.Group.ReadOnly {
    override val path: PathType =
      zio.aws.iam.model.primitives.PathType(impl.path())
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val groupId: IdType =
      zio.aws.iam.model.primitives.IdType(impl.groupId())
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.Group
  ): zio.aws.iam.model.Group.ReadOnly = new Wrapper(impl)
}
