package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  GroupNameType,
  PathType
}
import scala.jdk.CollectionConverters.*
final case class GroupDetail(
    path: Optional[PathType] = Optional.Absent,
    groupName: Optional[GroupNameType] = Optional.Absent,
    groupId: Optional[IdType] = Optional.Absent,
    arn: Optional[ArnType] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent,
    groupPolicyList: Optional[Iterable[zio.aws.iam.model.PolicyDetail]] =
      Optional.Absent,
    attachedManagedPolicies: Optional[
      Iterable[zio.aws.iam.model.AttachedPolicy]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.GroupDetail = {
    import GroupDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GroupDetail
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        groupName.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        groupPolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupPolicyList)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GroupDetail.ReadOnly =
    zio.aws.iam.model.GroupDetail.wrap(buildAwsValue())
}
object GroupDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.GroupDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GroupDetail =
      zio.aws.iam.model.GroupDetail(
        path.map(value => value),
        groupName.map(value => value),
        groupId.map(value => value),
        arn.map(value => value),
        createDate.map(value => value),
        groupPolicyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Optional[PathType]
    def groupName: Optional[GroupNameType]
    def groupId: Optional[IdType]
    def arn: Optional[ArnType]
    def createDate: Optional[DateType]
    def groupPolicyList: Optional[List[zio.aws.iam.model.PolicyDetail.ReadOnly]]
    def attachedManagedPolicies
        : Optional[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getGroupName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getGroupPolicyList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      AwsError.unwrapOptionField("groupPolicyList", groupPolicyList)
    def getAttachedManagedPolicies
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      AwsError.unwrapOptionField(
        "attachedManagedPolicies",
        attachedManagedPolicies
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GroupDetail
  ) extends zio.aws.iam.model.GroupDetail.ReadOnly {
    override val path: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val groupName: Optional[GroupNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.iam.model.primitives.GroupNameType(value))
    override val groupId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val groupPolicyList
        : Optional[List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupPolicyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.PolicyDetail.wrap(item)
          }.toList
        )
    override val attachedManagedPolicies
        : Optional[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedManagedPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.AttachedPolicy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GroupDetail
  ): zio.aws.iam.model.GroupDetail.ReadOnly = new Wrapper(impl)
}
