package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PolicyPathType,
  GroupNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAttachedGroupPoliciesRequest(
    groupName: GroupNameType,
    pathPrefix: Optional[PolicyPathType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest = {
    import ListAttachedGroupPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        pathPrefix.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAttachedGroupPoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListAttachedGroupPoliciesRequest.wrap(buildAwsValue())
}
object ListAttachedGroupPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAttachedGroupPoliciesRequest =
      zio.aws.iam.model.ListAttachedGroupPoliciesRequest(
        groupName,
        pathPrefix.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def groupName: GroupNameType
    def pathPrefix: Optional[PolicyPathType]
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPathPrefix: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
  ) extends zio.aws.iam.model.ListAttachedGroupPoliciesRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val pathPrefix: Optional[PolicyPathType] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
  ): zio.aws.iam.model.ListAttachedGroupPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
