package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PolicyPathType,
  RoleNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAttachedRolePoliciesRequest(
    roleName: RoleNameType,
    pathPrefix: Optional[PolicyPathType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest = {
    import ListAttachedRolePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .optionallyWith(
        pathPrefix.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAttachedRolePoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListAttachedRolePoliciesRequest.wrap(buildAwsValue())
}
object ListAttachedRolePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAttachedRolePoliciesRequest =
      zio.aws.iam.model.ListAttachedRolePoliciesRequest(
        roleName,
        pathPrefix.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def roleName: RoleNameType
    def pathPrefix: Optional[PolicyPathType]
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPathPrefix: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest
  ) extends zio.aws.iam.model.ListAttachedRolePoliciesRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val pathPrefix: Optional[PolicyPathType] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest
  ): zio.aws.iam.model.ListAttachedRolePoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
