package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PathType,
  ArnType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEntitiesForPolicyRequest(
    policyArn: ArnType,
    entityFilter: Optional[zio.aws.iam.model.EntityType] = Optional.Absent,
    pathPrefix: Optional[PathType] = Optional.Absent,
    policyUsageFilter: Optional[zio.aws.iam.model.PolicyUsageType] =
      Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest = {
    import ListEntitiesForPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .optionallyWith(entityFilter.map(value => value.unwrap))(_.entityFilter)
      .optionallyWith(
        pathPrefix.map(value => PathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(policyUsageFilter.map(value => value.unwrap))(
        _.policyUsageFilter
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListEntitiesForPolicyRequest.ReadOnly =
    zio.aws.iam.model.ListEntitiesForPolicyRequest.wrap(buildAwsValue())
}
object ListEntitiesForPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListEntitiesForPolicyRequest =
      zio.aws.iam.model.ListEntitiesForPolicyRequest(
        policyArn,
        entityFilter.map(value => value),
        pathPrefix.map(value => value),
        policyUsageFilter.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def policyArn: ArnType
    def entityFilter: Optional[zio.aws.iam.model.EntityType]
    def pathPrefix: Optional[PathType]
    def policyUsageFilter: Optional[zio.aws.iam.model.PolicyUsageType]
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getEntityFilter: ZIO[Any, AwsError, zio.aws.iam.model.EntityType] =
      AwsError.unwrapOptionField("entityFilter", entityFilter)
    def getPathPrefix: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getPolicyUsageFilter
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicyUsageType] =
      AwsError.unwrapOptionField("policyUsageFilter", policyUsageFilter)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
  ) extends zio.aws.iam.model.ListEntitiesForPolicyRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val entityFilter: Optional[zio.aws.iam.model.EntityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityFilter())
        .map(value => zio.aws.iam.model.EntityType.wrap(value))
    override val pathPrefix: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val policyUsageFilter
        : Optional[zio.aws.iam.model.PolicyUsageType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyUsageFilter())
      .map(value => zio.aws.iam.model.PolicyUsageType.wrap(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
  ): zio.aws.iam.model.ListEntitiesForPolicyRequest.ReadOnly = new Wrapper(impl)
}
