package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ResponseMarkerType,
  BooleanType,
  PolicyNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGroupPoliciesResponse(
    policyNames: Iterable[PolicyNameType],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse = {
    import ListGroupPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse
      .builder()
      .policyNames(policyNames.map { item =>
        PolicyNameType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly =
    zio.aws.iam.model.ListGroupPoliciesResponse.wrap(buildAwsValue())
}
object ListGroupPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListGroupPoliciesResponse =
      zio.aws.iam.model.ListGroupPoliciesResponse(
        policyNames,
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def policyNames: List[PolicyNameType]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getPolicyNames: ZIO[Any, Nothing, List[PolicyNameType]] =
      ZIO.succeed(policyNames)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse
  ) extends zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly {
    override val policyNames: List[PolicyNameType] = impl
      .policyNames()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.PolicyNameType(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse
  ): zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly = new Wrapper(impl)
}
